%% Description
% Plots figure 3a & 3b
% Fig 3a: the droplet radius and contact radius as a function of H_\infty 
% for \Gamma = 100.
% Fig 3b: the meniscus height as a function of H_\infty for \Gamma = 100.
%
% Data has been calculated by solving eqn (14) for non-contact solutions 
% and (16)-(18) for contact solutions for H_\infty from 2-15, \Gamma = 100. 

%% Paramter definitions
%
% Hinf(i)       Values of H_\infty used.
%
% j             Denotes the branch of solutions: 
%                       1 = stable non-contact, 
%                       2 = unstable, 
%                       3 = stable contact. 
%
% sol(i,j,k)    Solution for droplet radius R, meniscus height H, and
%               contact radius C.
%               i: solution when H_\inf = Hinf(i).
%               j: type of solution, as described above.
%               k: when k=[1 2 3] solution is for [R H C].
%
% [a b c]       Values of i at which change from one solution to three and
%               back to one.
%
% contact       Value of i where solution changes (continuously) contact to
%               non-contact (in this case on unstable branch between a and
%               b).
%
% col           Colour scheme for plotting.

clear all;close all;

%% Load solution
load('figure3.mat')

%% Plotting
col = ['b' 'b' 'r'];

for k=1:3
    if k==2
        figure(2)
    else
        figure(1)
    end
    
    if k~=3
    % Plot non-contact
    plot(Hinf(1:a),sol(1:a,1,k),'color',col(k),'linestyle','-','linewidth',2)
    hold on
    plot(Hinf(a:b),sol(a:b,1,k),'color',col(k),'linestyle','-','linewidth',2)
    % Plot unstable solution
    plot(Hinf(a+1:b),sol(a+1:b,2,k),'color',col(k),'linestyle','--','linewidth',2)
    elseif k==3
        plot(Hinf(a+1:contact),sol(a+1:contact,2,k),'color',col(k),'linestyle','--','linewidth',2)
    end
    % Plot contact
    plot(Hinf(a+1:b),sol(a+1:b,3,k),'color',col(k),'linestyle','-','linewidth',4)
    plot(Hinf(b:c),sol(b:c,3,k),'color',col(k),'linestyle','-','linewidth',4)
end


hold off

figure(1)
xlabel('$H_\infty$','interpreter','latex')
ylabel('$R_M, C$','interpreter','latex')

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))


figure(2)
plot(Hinf,Hinf,'k:')
xlabel('$H_\infty$','interpreter','latex')
ylabel('$H_M$','interpreter','latex')

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))
